# adminbot/access_control.py - MODULE DE SERVICES DE SÉCURITÉ (Refactorisé)

from typing import TYPE_CHECKING, Set
from mautrix.types import UserID, RoomID
import asyncio

if TYPE_CHECKING:
    from .__init__ import AdminBot

# MODIFIÉ : La fonction utilise maintenant le set directement depuis la config.
def is_authorized(user_id: UserID, authorized_users_set: Set[UserID]) -> bool:
    """
    Vérifie si le MXID donné est dans le set des utilisateurs autorisés.
    La vérification est faite après normalisation en minuscules.
    """
    return user_id.lower() in authorized_users_set

async def refuse_and_leave(plugin: 'AdminBot', room_id: RoomID, unauthorized_user_id: UserID):
    """
    Tâche atomique pour envoyer un message de refus et quitter la salle.
    (Inchangé)
    """
    plugin.log.warning(f"🚫 SÉCURITÉ: Déclenchement du départ forcé de la salle {room_id} à cause de l'utilisateur {unauthorized_user_id}.")
    
    refusal_message = plugin.config["refusal_message"].format(inviter_id=unauthorized_user_id)
    
    async def refuse_task():
        try:
            await plugin.client.send_text(room_id, refusal_message)
            await plugin.client.leave_room(room_id)
            plugin.log.info(f"🚪 DÉPART FORCÉ: Départ de {room_id} initié avec succès.")
        except Exception as e:
            plugin.log.error(f"Erreur lors de l'exécution de la tâche de refus/départ pour {room_id}: {e}")
        finally:
            if room_id in plugin.processing_invites:
                plugin.processing_invites.remove(room_id)

    asyncio.create_task(refuse_task())
