# adminbot/commands/help.py

from maubot.client import MaubotMatrixClient
from mautrix.types import RoomID
from ..utils import MIGRATE_LEGEND_ICONS # NOUVEL IMPORT

# MODIFIÉ : La légende est construite dynamiquement
def generate_help_message() -> str:
    legend_section = "📖 **Légende des Icônes du Rapport de Migration :**\n"
    for icon, description in MIGRATE_LEGEND_ICONS.items():
        if icon in ("📨", "🚪", "⚡️", "👋"):
            action_map = {
                "📨": "Le bot va inviter le compte de destination dans le salon.",
                "🚪": "Le compte de destination va accepter l'invitation et rejoindre le salon.",
                "⚡️": "Les niveaux de pouvoir du compte source (si admin/mod) seront répliqués sur le compte destination.",
                "👋": "Le compte source quittera le salon (uniquement avec l'option `--leave`)."
            }
            legend_section += f"  - {icon} **{description}** : {action_map.get(icon, '')}\n"
        elif icon in ("✅", "⚪", "❌"):
            status_map = {
                "✅": "L'opération sur le salon est (ou serait) un succès.",
                "⚪": "Aucune action n'est prise (salon 1-1, ancien salon, ou destination déjà membre).",
                "❌": "Une erreur a empêché le traitement du salon."
            }
            legend_section += f"  - {icon} **{description}** : {status_map.get(icon, '')}\n"

    return (
        "🤖 **Commandes Administratives AdminBot :**\n"
        "Les commandes nécessitent le préfixe `!admin` et sont réservées aux utilisateurs autorisés.\n\n"
        
        "🔑 **Gestion de Compte (Requiert TOKEN Admin) :**\n"
        "  - `!admin lastseens <SERVER_URL> <JOURS> <TOKEN>` : Liste les utilisateurs **actifs/vus récemment**.\n" 
        "  - `!admin lastregisters <SERVER_URL> <JOURS> <TOKEN>` : Liste les utilisateurs **nouvellement enregistrés**.\n"
        "      - `SERVER_URL` : L'adresse complète du homeserver (ex: `https://matrix.example.com`).\n"
        "      - `JOURS` : Nombre de jours à prendre en compte.\n"
        "      - `TOKEN` : Token d'accès **Administrateur Synapse** (doit être non expiré).\n\n"
        
        "🔄 **Migration/Nettoyage (Requiert Access Tokens) :**\n"
        "  - `!admin migrate from <@user_source:domain> <TOKEN_SOURCE> to <@user_dest:domain> <TOKEN_DESTINATION> [ --do-it ] [ --leave ]` : \n" 
        "      - **Mode Simulation par défaut.** Effectue la synchronisation des salles entre deux comptes. **Requiert les Tokens d'Accès.**\n"
        "      - `--do-it` : Active l'exécution réelle des changements. (⚠ Irréversible)\n"
        "      - `--leave` : Fait quitter toutes les salles au compte SOURCE après la synchronisation.\n\n"
        
        "--- \n"
        f"{legend_section}\n"
        "--- \n"
        "ℹ️ **Aide Générale :**\n"
        "  - `!help` ou `help` : Affiche ce message."
    )

HELP_MESSAGE = generate_help_message()

async def execute_help(client: MaubotMatrixClient, room_id: RoomID) -> None:
    """Affiche le message d'aide."""
    await client.send_text(room_id, HELP_MESSAGE)
